#include <iostream>
#include <cmath>
#include <cstdio>
#include <string>
using namespace std;

typedef long long ll;

//double vw[61000], pf[61000], vf[61000], th[61000];
double *vw, *pf, *vf, *th;
int N;
double pw;

double EPS = 1e-4;

double cost(double W)
{
    double tot_cost = 0.0;
    for(int i = 0; i < N; ++i){
        tot_cost += max((th[i] - W * vw[i])/vf[i] , 0.0) * pf[i];
    }
    return tot_cost;
}


int main() {

    
    while( cin >> N >> pw && N != 0 ) {

        vw = new double[N];
        pf = new double[N];
        vf = new double[N];
        th = new double[N];


        for(int i = 0; i < N; ++i){
            cin >> vw[i] >> pf[i] >> vf[i] >> th[i];
            // cout << vw[i] << " " << pf[i]  << " " << vf[i]  << " " << th[i] << endl;
        }


        //double min_cost = INFINITY;
        double hi = 1e8;
        //for(int i = 0; i < N; ++i){
        //    double W = th[i] / vw[i]; 
        //    hi = max(hi, W);
        //    //double tot_cost = W*pw + cost(W);
        //    //min_cost = min(min_cost, tot_cost);
        //}

        //cout << hi << " = W" << endl;
        double lo = 0.0;
        while (abs(hi - lo) > 1e-6) {
            double m1 = lo + 1 * (hi - lo) / 3.0;
            double m2 = lo + 2 * (hi - lo) / 3.0;

            if (m1*pw + cost(m1) < m2*pw + cost(m2)) {
                hi = m2;
            } else {
                lo = m1;
            }
        }

        printf("%0.10lf\n", hi * pw + cost(hi));
        //cout << hi*pw + cost(hi) << endl;
    }

    return 0;
}
